<?php

namespace Import\ApiBundle\Services\Import;


class ImportPKD extends ImportMainService
{
    protected $url = '../../../../../web/PKD2007.csv';

    protected $columns = array("Section","Division","Group","Class","Subclass","Name");

    protected $type = 'PKD';

    public function import()
    {
        $this->url = __DIR__.'/'.$this->url;
        $data = $this->getCSV($this->url,$this->columns,";");
        $isHeadRow = true;

        $Objects = array('ROOT' => $this->createRoot());

        foreach($this->columns as $column)
        {
            $Objects[$column] = $column;
        }

        $countRow = count($data);
        $count = 0;
        foreach($data as $id => $row)
        {
            $this->printPercent($id,$countRow);
            if($isHeadRow)
            {
                $isHeadRow = false;
                continue;
            }

            foreach($this->columns as $id => $column)
            {
                if(isset($row[$column]) && !empty($row[$column]) && $row[$column] != '' && $column != 'Name')
                {
                    $data = array(
                        'Name' => $row['Name'],
                        'Symbol' => (empty($row['Subclass'])) ? $row[$column] : $row['Subclass'],
                        'Parent' => ($id > 0) ? $Objects[$this->columns[($id-1)]] : $Objects['ROOT'],
                    );
                    $Objects[$column] = $this->getDoctrine()->getRepository('ImportApiBundle:PKD')->add($data);
                    $count++;
                    break;
                }
            }
        }

        echo "\r\nSAVE... ";
        $this->getDoctrine()->getEntityManager()->flush();
        echo 'DONE'."\r\n";

        return array('count' => $count);
    }

    protected function createRoot()
    {
        $data = array(
            'Name' => 'PKD tree ROOT',
            'Symbol' => 'ROOT',
        );

        return $this->getDoctrine()->getRepository('ImportApiBundle:PKD')->add($data);
    }

    protected function save($data)
    {
        $data['Currency'] = $this->getCurrencyBySymbol($data['Name']);
        $SessionIndexGPW = $this->getDoctrine()->getRepository('ImportApiBundle:SessionCurrency')->add($data);

        return $SessionIndexGPW;
    }
}